package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIntentPathsResponse(
    nodeSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse = {
    import ListIntentPathsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse
      .builder()
      .optionallyWith(
        nodeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListIntentPathsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentPathsResponse.wrap(buildAwsValue())
}
object ListIntentPathsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentPathsResponse =
      zio.aws.lexmodelsv2.model.ListIntentPathsResponse(
        nodeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nodeSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly]
    ]
    def getNodeSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeSummaries", nodeSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse
  ) extends zio.aws.lexmodelsv2.model.ListIntentPathsResponse.ReadOnly {
    override val nodeSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentNodeSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse
  ): zio.aws.lexmodelsv2.model.ListIntentPathsResponse.ReadOnly = new Wrapper(
    impl
  )
}
