package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{PresignedS3Url, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTestExecutionArtifactsUrlResponse(
    testExecutionId: Optional[Id] = Optional.Absent,
    downloadArtifactsUrl: Optional[PresignedS3Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse = {
    import GetTestExecutionArtifactsUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
      .builder()
      .optionallyWith(
        testExecutionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testExecutionId)
      .optionallyWith(
        downloadArtifactsUrl.map(value =>
          PresignedS3Url.unwrap(value): java.lang.String
        )
      )(_.downloadArtifactsUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
      .wrap(buildAwsValue())
}
object GetTestExecutionArtifactsUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse =
      zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse(
        testExecutionId.map(value => value),
        downloadArtifactsUrl.map(value => value)
      )
    def testExecutionId: Optional[Id]
    def downloadArtifactsUrl: Optional[PresignedS3Url]
    def getTestExecutionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testExecutionId", testExecutionId)
    def getDownloadArtifactsUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("downloadArtifactsUrl", downloadArtifactsUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
  ) extends zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse.ReadOnly {
    override val testExecutionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testExecutionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val downloadArtifactsUrl: Optional[PresignedS3Url] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadArtifactsUrl())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
  ): zio.aws.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse.ReadOnly =
    new Wrapper(impl)
}
