package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsIntentStageMetricResult(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName] =
      Optional.Absent,
    statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      Optional.Absent,
    value: Optional[AnalyticsMetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult = {
    import AnalyticsIntentStageMetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => AnalyticsMetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult
      .wrap(buildAwsValue())
}
object AnalyticsIntentStageMetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult =
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName]
    def statistic: Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic]
    def value: Optional[AnalyticsMetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, AnalyticsMetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricName.wrap(value)
        )
    override val statistic
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(value)
        )
    override val value: Optional[AnalyticsMetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsMetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentStageMetricResult.ReadOnly =
    new Wrapper(impl)
}
