package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsIntentMetric(
    name: zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName,
    statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic,
    order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric = {
    import AnalyticsIntentMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric
      .builder()
      .name(name.unwrap)
      .statistic(statistic.unwrap)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.wrap(buildAwsValue())
}
object AnalyticsIntentMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentMetric =
      zio.aws.lexmodelsv2.model
        .AnalyticsIntentMetric(name, statistic, order.map(value => value))
    def name: zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName
    def statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    def order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName
    ] = ZIO.succeed(name)
    def getStatistic: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = ZIO.succeed(statistic)
    def getOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName =
      zio.aws.lexmodelsv2.model.AnalyticsIntentMetricName.wrap(impl.name())
    override val statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic =
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(impl.statistic())
    override val order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentMetric.ReadOnly = new Wrapper(
    impl
  )
}
