package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait AnalyticsIntentFilterName {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName
}
object AnalyticsIntentFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.BOT_ALIAS_ID =>
      val r = BotAliasId
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.BOT_VERSION =>
      val r = BotVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.LOCALE_ID =>
      val r = LocaleId
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.MODALITY =>
      val r = Modality
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.CHANNEL =>
      val r = Channel
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.SESSION_ID =>
      val r = SessionId
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.ORIGINATING_REQUEST_ID =>
      val r = OriginatingRequestId
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.INTENT_NAME =>
      val r = IntentName
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.INTENT_END_STATE =>
      val r = IntentEndState
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object BotAliasId
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.BOT_ALIAS_ID
  }
  case object BotVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.BOT_VERSION
  }
  case object LocaleId
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.LOCALE_ID
  }
  case object Modality
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.MODALITY
  }
  case object Channel
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.CHANNEL
  }
  case object SessionId
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.SESSION_ID
  }
  case object OriginatingRequestId
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.ORIGINATING_REQUEST_ID
  }
  case object IntentName
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.INTENT_NAME
  }
  case object IntentEndState
      extends zio.aws.lexmodelsv2.model.AnalyticsIntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilterName.INTENT_END_STATE
  }
}
