package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{S3ObjectPath, S3BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestSetImportInputLocation(
    s3BucketName: S3BucketName,
    s3Path: S3ObjectPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation = {
    import TestSetImportInputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .s3Path(S3ObjectPath.unwrap(s3Path): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetImportInputLocation.wrap(buildAwsValue())
}
object TestSetImportInputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetImportInputLocation =
      zio.aws.lexmodelsv2.model.TestSetImportInputLocation(s3BucketName, s3Path)
    def s3BucketName: S3BucketName
    def s3Path: S3ObjectPath
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getS3Path: ZIO[Any, Nothing, S3ObjectPath] = ZIO.succeed(s3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation
  ) extends zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.lexmodelsv2.model.primitives.S3BucketName(impl.s3BucketName())
    override val s3Path: S3ObjectPath =
      zio.aws.lexmodelsv2.model.primitives.S3ObjectPath(impl.s3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportInputLocation
  ): zio.aws.lexmodelsv2.model.TestSetImportInputLocation.ReadOnly =
    new Wrapper(impl)
}
