package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait TestSetGenerationStatus {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus
}
object TestSetGenerationStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus
  ): zio.aws.lexmodelsv2.model.TestSetGenerationStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.GENERATING =>
      val r = Generating
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.READY =>
      val r = Ready
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.PENDING =>
      val r = Pending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestSetGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Generating
      extends zio.aws.lexmodelsv2.model.TestSetGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.GENERATING
  }
  case object Ready extends zio.aws.lexmodelsv2.model.TestSetGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.READY
  }
  case object Failed extends zio.aws.lexmodelsv2.model.TestSetGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.FAILED
  }
  case object Pending
      extends zio.aws.lexmodelsv2.model.TestSetGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus.PENDING
  }
}
