package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTestExecutionRequest(
    testSetId: Id,
    target: zio.aws.lexmodelsv2.model.TestExecutionTarget,
    apiMode: zio.aws.lexmodelsv2.model.TestExecutionApiMode,
    testExecutionModality: Optional[
      zio.aws.lexmodelsv2.model.TestExecutionModality
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest = {
    import StartTestExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .target(target.buildAwsValue())
      .apiMode(apiMode.unwrap)
      .optionallyWith(testExecutionModality.map(value => value.unwrap))(
        _.testExecutionModality
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.StartTestExecutionRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.StartTestExecutionRequest.wrap(buildAwsValue())
}
object StartTestExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartTestExecutionRequest =
      zio.aws.lexmodelsv2.model.StartTestExecutionRequest(
        testSetId,
        target.asEditable,
        apiMode,
        testExecutionModality.map(value => value)
      )
    def testSetId: Id
    def target: zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly
    def apiMode: zio.aws.lexmodelsv2.model.TestExecutionApiMode
    def testExecutionModality
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionModality]
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
    def getTarget: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly
    ] = ZIO.succeed(target)
    def getApiMode
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestExecutionApiMode] =
      ZIO.succeed(apiMode)
    def getTestExecutionModality
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestExecutionModality] =
      AwsError.unwrapOptionField("testExecutionModality", testExecutionModality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest
  ) extends zio.aws.lexmodelsv2.model.StartTestExecutionRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
    override val target
        : zio.aws.lexmodelsv2.model.TestExecutionTarget.ReadOnly =
      zio.aws.lexmodelsv2.model.TestExecutionTarget.wrap(impl.target())
    override val apiMode: zio.aws.lexmodelsv2.model.TestExecutionApiMode =
      zio.aws.lexmodelsv2.model.TestExecutionApiMode.wrap(impl.apiMode())
    override val testExecutionModality
        : Optional[zio.aws.lexmodelsv2.model.TestExecutionModality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testExecutionModality())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestExecutionModality.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest
  ): zio.aws.lexmodelsv2.model.StartTestExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
