package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SessionDataSortBy(
    name: zio.aws.lexmodelsv2.model.AnalyticsSessionSortByName,
    order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SessionDataSortBy = {
    import SessionDataSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SessionDataSortBy
      .builder()
      .name(name.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SessionDataSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.SessionDataSortBy.wrap(buildAwsValue())
}
object SessionDataSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SessionDataSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SessionDataSortBy =
      zio.aws.lexmodelsv2.model.SessionDataSortBy(name, order)
    def name: zio.aws.lexmodelsv2.model.AnalyticsSessionSortByName
    def order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsSessionSortByName
    ] = ZIO.succeed(name)
    def getOrder
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SessionDataSortBy
  ) extends zio.aws.lexmodelsv2.model.SessionDataSortBy.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsSessionSortByName =
      zio.aws.lexmodelsv2.model.AnalyticsSessionSortByName.wrap(impl.name())
    override val order: zio.aws.lexmodelsv2.model.AnalyticsSortOrder =
      zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SessionDataSortBy
  ): zio.aws.lexmodelsv2.model.SessionDataSortBy.ReadOnly = new Wrapper(impl)
}
