package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIntentStageMetricsResponse(
    botId: Optional[Id] = Optional.Absent,
    results: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse = {
    import ListIntentStageMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse
      .wrap(buildAwsValue())
}
object ListIntentStageMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse =
      zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse(
        botId.map(value => value),
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Optional[Id]
    def results: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse
  ) extends zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val results: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.results())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsIntentStageResult.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse
  ): zio.aws.lexmodelsv2.model.ListIntentStageMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
