package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImportsResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    importSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.ImportSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse = {
    import ListImportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        importSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListImportsResponse.wrap(buildAwsValue())
}
object ListImportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListImportsResponse =
      zio.aws.lexmodelsv2.model.ListImportsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        importSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def importSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def localeId: Optional[LocaleId]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getImportSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("importSummaries", importSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ) extends zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val importSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ImportSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ): zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly = new Wrapper(impl)
}
