package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExecutionErrorDetails(
    errorCode: NonEmptyString,
    errorMessage: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails = {
    import ExecutionErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails
      .builder()
      .errorCode(NonEmptyString.unwrap(errorCode): java.lang.String)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly =
    zio.aws.lexmodelsv2.model.ExecutionErrorDetails.wrap(buildAwsValue())
}
object ExecutionErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExecutionErrorDetails =
      zio.aws.lexmodelsv2.model.ExecutionErrorDetails(errorCode, errorMessage)
    def errorCode: NonEmptyString
    def errorMessage: NonEmptyString
    def getErrorCode: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails
  ) extends zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly {
    override val errorCode: NonEmptyString =
      zio.aws.lexmodelsv2.model.primitives.NonEmptyString(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.lexmodelsv2.model.primitives.NonEmptyString(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails
  ): zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly = new Wrapper(
    impl
  )
}
