package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class CreateTestSetDiscrepancyReportResponse(
    testSetDiscrepancyReportId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    testSetId: Optional[Id] = Optional.Absent,
    target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse = {
    import CreateTestSetDiscrepancyReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
      .builder()
      .optionallyWith(
        testSetDiscrepancyReportId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.testSetDiscrepancyReportId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        testSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetId)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
      .wrap(buildAwsValue())
}
object CreateTestSetDiscrepancyReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse =
      zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse(
        testSetDiscrepancyReportId.map(value => value),
        creationDateTime.map(value => value),
        testSetId.map(value => value),
        target.map(value => value.asEditable)
      )
    def testSetDiscrepancyReportId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def testSetId: Optional[Id]
    def target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ]
    def getTestSetDiscrepancyReportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "testSetDiscrepancyReportId",
        testSetDiscrepancyReportId
      )
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getTestSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetId", testSetId)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
  ) extends zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse.ReadOnly {
    override val testSetDiscrepancyReportId: Optional[Id] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetDiscrepancyReportId())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val testSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
  ): zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse.ReadOnly =
    new Wrapper(impl)
}
