package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConditionalBranch(
    name: Name,
    condition: zio.aws.lexmodelsv2.model.Condition,
    nextStep: zio.aws.lexmodelsv2.model.DialogState,
    response: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch = {
    import ConditionalBranch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .condition(condition.buildAwsValue())
      .nextStep(nextStep.buildAwsValue())
      .optionallyWith(response.map(value => value.buildAwsValue()))(_.response)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly =
    zio.aws.lexmodelsv2.model.ConditionalBranch.wrap(buildAwsValue())
}
object ConditionalBranch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConditionalBranch =
      zio.aws.lexmodelsv2.model.ConditionalBranch(
        name,
        condition.asEditable,
        nextStep.asEditable,
        response.map(value => value.asEditable)
      )
    def name: Name
    def condition: zio.aws.lexmodelsv2.model.Condition.ReadOnly
    def nextStep: zio.aws.lexmodelsv2.model.DialogState.ReadOnly
    def response
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCondition
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.Condition.ReadOnly] =
      ZIO.succeed(condition)
    def getNextStep
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      ZIO.succeed(nextStep)
    def getResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("response", response)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch
  ) extends zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly {
    override val name: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.name())
    override val condition: zio.aws.lexmodelsv2.model.Condition.ReadOnly =
      zio.aws.lexmodelsv2.model.Condition.wrap(impl.condition())
    override val nextStep: zio.aws.lexmodelsv2.model.DialogState.ReadOnly =
      zio.aws.lexmodelsv2.model.DialogState.wrap(impl.nextStep())
    override val response
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.response())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch
  ): zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly = new Wrapper(impl)
}
