package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait BotType {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.BotType
}
object BotType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.BotType
  ): zio.aws.lexmodelsv2.model.BotType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.BotType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.BotType.BOT =>
      val r = Bot
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.BotType.BOT_NETWORK =>
      val r = BotNetwork
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexmodelsv2.model.BotType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.BotType =
      software.amazon.awssdk.services.lexmodelsv2.model.BotType.UNKNOWN_TO_SDK_VERSION
  }
  case object Bot extends zio.aws.lexmodelsv2.model.BotType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.BotType =
      software.amazon.awssdk.services.lexmodelsv2.model.BotType.BOT
  }
  case object BotNetwork extends zio.aws.lexmodelsv2.model.BotType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.BotType =
      software.amazon.awssdk.services.lexmodelsv2.model.BotType.BOT_NETWORK
  }
}
