package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Name, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserTurnSlotOutput(
    value: Optional[NonEmptyString] = Optional.Absent,
    values: Optional[Iterable[zio.aws.lexmodelsv2.model.UserTurnSlotOutput]] =
      Optional.Absent,
    subSlots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput = {
    import UserTurnSlotOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        subSlots.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.subSlots)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly =
    zio.aws.lexmodelsv2.model.UserTurnSlotOutput.wrap(buildAwsValue())
}
object UserTurnSlotOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UserTurnSlotOutput =
      zio.aws.lexmodelsv2.model.UserTurnSlotOutput(
        value.map(value => value),
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subSlots.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def value: Optional[NonEmptyString]
    def values
        : Optional[List[zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]]
    def subSlots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]
    ]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("values", values)
    def getSubSlots: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("subSlots", subSlots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput
  ) extends zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly {
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NonEmptyString(value))
    override val values: Optional[
      List[zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.UserTurnSlotOutput.wrap(item)
        }.toList
      )
    override val subSlots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subSlots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.Name(
              key
            ) -> zio.aws.lexmodelsv2.model.UserTurnSlotOutput.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput
  ): zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly = new Wrapper(impl)
}
