package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestSetSlotDiscrepancyItem(
    intentName: Name,
    slotName: Name,
    errorMessage: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem = {
    import TestSetSlotDiscrepancyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .slotName(Name.unwrap(slotName): java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.wrap(buildAwsValue())
}
object TestSetSlotDiscrepancyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem =
      zio.aws.lexmodelsv2.model
        .TestSetSlotDiscrepancyItem(intentName, slotName, errorMessage)
    def intentName: Name
    def slotName: Name
    def errorMessage: String
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getSlotName: ZIO[Any, Nothing, Name] = ZIO.succeed(slotName)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem
  ) extends zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val slotName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.slotName())
    override val errorMessage: String = impl.errorMessage(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetSlotDiscrepancyItem
  ): zio.aws.lexmodelsv2.model.TestSetSlotDiscrepancyItem.ReadOnly =
    new Wrapper(impl)
}
