package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestExecutionSortBy(
    attribute: zio.aws.lexmodelsv2.model.TestExecutionSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSortBy = {
    import TestExecutionSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestExecutionSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.TestExecutionSortBy.wrap(buildAwsValue())
}
object TestExecutionSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestExecutionSortBy =
      zio.aws.lexmodelsv2.model.TestExecutionSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.TestExecutionSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestExecutionSortAttribute
    ] = ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSortBy
  ) extends zio.aws.lexmodelsv2.model.TestExecutionSortBy.ReadOnly {
    override val attribute
        : zio.aws.lexmodelsv2.model.TestExecutionSortAttribute =
      zio.aws.lexmodelsv2.model.TestExecutionSortAttribute
        .wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSortBy
  ): zio.aws.lexmodelsv2.model.TestExecutionSortBy.ReadOnly = new Wrapper(impl)
}
