package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  TagValue,
  Description,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTestSetGenerationRequest(
    testSetName: Name,
    description: Optional[Description] = Optional.Absent,
    storageLocation: zio.aws.lexmodelsv2.model.TestSetStorageLocation,
    generationDataSource: zio.aws.lexmodelsv2.model.TestSetGenerationDataSource,
    roleArn: RoleArn,
    testSetTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest = {
    import StartTestSetGenerationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest
      .builder()
      .testSetName(Name.unwrap(testSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .storageLocation(storageLocation.buildAwsValue())
      .generationDataSource(generationDataSource.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        testSetTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testSetTags)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest
      .wrap(buildAwsValue())
}
object StartTestSetGenerationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest =
      zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest(
        testSetName,
        description.map(value => value),
        storageLocation.asEditable,
        generationDataSource.asEditable,
        roleArn,
        testSetTags.map(value => value)
      )
    def testSetName: Name
    def description: Optional[Description]
    def storageLocation
        : zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    def generationDataSource
        : zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    def roleArn: RoleArn
    def testSetTags: Optional[Map[TagKey, TagValue]]
    def getTestSetName: ZIO[Any, Nothing, Name] = ZIO.succeed(testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStorageLocation: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    ] = ZIO.succeed(storageLocation)
    def getGenerationDataSource: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ] = ZIO.succeed(generationDataSource)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTestSetTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testSetTags", testSetTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest
  ) extends zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest.ReadOnly {
    override val testSetName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.testSetName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val storageLocation
        : zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetStorageLocation
        .wrap(impl.storageLocation())
    override val generationDataSource
        : zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource
        .wrap(impl.generationDataSource())
    override val roleArn: RoleArn =
      zio.aws.lexmodelsv2.model.primitives.RoleArn(impl.roleArn())
    override val testSetTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives.TagKey(
                key
              ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest
  ): zio.aws.lexmodelsv2.model.StartTestSetGenerationRequest.ReadOnly =
    new Wrapper(impl)
}
