package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OverallTestResults(
    items: Iterable[zio.aws.lexmodelsv2.model.OverallTestResultItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResults = {
    import OverallTestResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResults
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly =
    zio.aws.lexmodelsv2.model.OverallTestResults.wrap(buildAwsValue())
}
object OverallTestResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.OverallTestResults =
      zio.aws.lexmodelsv2.model.OverallTestResults(items.map { item =>
        item.asEditable
      })
    def items: List[zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResults
  ) extends zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly {
    override val items
        : List[zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.OverallTestResultItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResults
  ): zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly = new Wrapper(impl)
}
