package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListUtteranceAnalyticsDataResponse(
    botId: Optional[Id] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    utterances: Optional[
      Iterable[zio.aws.lexmodelsv2.model.UtteranceSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse = {
    import ListUtteranceAnalyticsDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        utterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utterances)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
      .wrap(buildAwsValue())
}
object ListUtteranceAnalyticsDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse =
      zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse(
        botId.map(value => value),
        nextToken.map(value => value),
        utterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Optional[Id]
    def nextToken: Optional[NextToken]
    def utterances: Optional[
      List[zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly]
    ]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("utterances", utterances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
  ) extends zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val utterances: Optional[
      List[zio.aws.lexmodelsv2.model.UtteranceSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utterances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.UtteranceSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
  ): zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse.ReadOnly =
    new Wrapper(impl)
}
