package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IntentLevelSlotResolutionTestResultItem(
    intentName: Name,
    multiTurnConversation: Boolean,
    slotResolutionResults: Iterable[
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem = {
    import IntentLevelSlotResolutionTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .multiTurnConversation(multiTurnConversation: java.lang.Boolean)
      .slotResolutionResults(slotResolutionResults.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem
      .wrap(buildAwsValue())
}
object IntentLevelSlotResolutionTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem =
      zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem(
        intentName,
        multiTurnConversation,
        slotResolutionResults.map { item =>
          item.asEditable
        }
      )
    def intentName: Name
    def multiTurnConversation: Boolean
    def slotResolutionResults
        : List[zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly]
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getMultiTurnConversation: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(multiTurnConversation)
    def getSlotResolutionResults: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly
    ]] = ZIO.succeed(slotResolutionResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem
  ) extends zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val multiTurnConversation: Boolean =
      impl.multiTurnConversation(): Boolean
    override val slotResolutionResults: List[
      zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.ReadOnly
    ] = impl
      .slotResolutionResults()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.SlotResolutionTestResultItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem
  ): zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResultItem.ReadOnly =
    new Wrapper(impl)
}
