package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Name,
  ImportedResourceId,
  Id
}
import scala.jdk.CollectionConverters._
final case class ImportSummary(
    importId: Optional[Id] = Optional.Absent,
    importedResourceId: Optional[ImportedResourceId] = Optional.Absent,
    importedResourceName: Optional[Name] = Optional.Absent,
    importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      Optional.Absent,
    mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    importedResourceType: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary = {
    import ImportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        importedResourceId.map(value =>
          ImportedResourceId.unwrap(value): java.lang.String
        )
      )(_.importedResourceId)
      .optionallyWith(
        importedResourceName.map(value => Name.unwrap(value): java.lang.String)
      )(_.importedResourceName)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(mergeStrategy.map(value => value.unwrap))(_.mergeStrategy)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(importedResourceType.map(value => value.unwrap))(
        _.importedResourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportSummary.wrap(buildAwsValue())
}
object ImportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportSummary =
      zio.aws.lexmodelsv2.model.ImportSummary(
        importId.map(value => value),
        importedResourceId.map(value => value),
        importedResourceName.map(value => value),
        importStatus.map(value => value),
        mergeStrategy.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        importedResourceType.map(value => value)
      )
    def importId: Optional[Id]
    def importedResourceId: Optional[ImportedResourceId]
    def importedResourceName: Optional[Name]
    def importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus]
    def mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def importedResourceType
        : Optional[zio.aws.lexmodelsv2.model.ImportResourceType]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getImportedResourceId: ZIO[Any, AwsError, ImportedResourceId] =
      AwsError.unwrapOptionField("importedResourceId", importedResourceId)
    def getImportedResourceName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("importedResourceName", importedResourceName)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getMergeStrategy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.MergeStrategy] =
      AwsError.unwrapOptionField("mergeStrategy", mergeStrategy)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getImportedResourceType
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportResourceType] =
      AwsError.unwrapOptionField("importedResourceType", importedResourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ) extends zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly {
    override val importId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val importedResourceId: Optional[ImportedResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedResourceId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ImportedResourceId(value)
        )
    override val importedResourceName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.importedResourceName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val importStatus
        : Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
    override val mergeStrategy
        : Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeStrategy())
        .map(value => zio.aws.lexmodelsv2.model.MergeStrategy.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val importedResourceType
        : Optional[zio.aws.lexmodelsv2.model.ImportResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedResourceType())
        .map(value => zio.aws.lexmodelsv2.model.ImportResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ): zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly = new Wrapper(impl)
}
