package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBotResponse(
    botId: Optional[Id] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse = {
    import DeleteBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotResponse.wrap(buildAwsValue())
}
object DeleteBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotResponse =
      zio.aws.lexmodelsv2.model.DeleteBotResponse(
        botId.map(value => value),
        botStatus.map(value => value)
      )
    def botId: Optional[Id]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly = new Wrapper(impl)
}
