package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.TestSetConversationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConversationLevelTestResultItem(
    conversationId: TestSetConversationId,
    endToEndResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus,
    speechTranscriptionResult: Optional[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
    ] = Optional.Absent,
    intentClassificationResults: Iterable[
      zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
    ],
    slotResolutionResults: Iterable[
      zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelTestResultItem = {
    import ConversationLevelTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelTestResultItem
      .builder()
      .conversationId(
        TestSetConversationId.unwrap(conversationId): java.lang.String
      )
      .endToEndResult(endToEndResult.unwrap)
      .optionallyWith(speechTranscriptionResult.map(value => value.unwrap))(
        _.speechTranscriptionResult
      )
      .intentClassificationResults(intentClassificationResults.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .slotResolutionResults(slotResolutionResults.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem
      .wrap(buildAwsValue())
}
object ConversationLevelTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem =
      zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem(
        conversationId,
        endToEndResult,
        speechTranscriptionResult.map(value => value),
        intentClassificationResults.map { item =>
          item.asEditable
        },
        slotResolutionResults.map { item =>
          item.asEditable
        }
      )
    def conversationId: TestSetConversationId
    def endToEndResult: zio.aws.lexmodelsv2.model.TestResultMatchStatus
    def speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def intentClassificationResults: List[
      zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly
    ]
    def slotResolutionResults: List[
      zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly
    ]
    def getConversationId: ZIO[Any, Nothing, TestSetConversationId] =
      ZIO.succeed(conversationId)
    def getEndToEndResult
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      ZIO.succeed(endToEndResult)
    def getSpeechTranscriptionResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField(
        "speechTranscriptionResult",
        speechTranscriptionResult
      )
    def getIntentClassificationResults: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly
    ]] = ZIO.succeed(intentClassificationResults)
    def getSlotResolutionResults: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly
    ]] = ZIO.succeed(slotResolutionResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelTestResultItem
  ) extends zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem.ReadOnly {
    override val conversationId: TestSetConversationId =
      zio.aws.lexmodelsv2.model.primitives
        .TestSetConversationId(impl.conversationId())
    override val endToEndResult
        : zio.aws.lexmodelsv2.model.TestResultMatchStatus =
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
        .wrap(impl.endToEndResult())
    override val speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speechTranscriptionResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
    override val intentClassificationResults: List[
      zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem.ReadOnly
    ] = impl
      .intentClassificationResults()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem
          .wrap(item)
      }
      .toList
    override val slotResolutionResults: List[
      zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem.ReadOnly
    ] = impl
      .slotResolutionResults()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelTestResultItem
  ): zio.aws.lexmodelsv2.model.ConversationLevelTestResultItem.ReadOnly =
    new Wrapper(impl)
}
