package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsUtteranceMetric(
    name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName,
    statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic,
    order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetric = {
    import AnalyticsUtteranceMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetric
      .builder()
      .name(name.unwrap)
      .statistic(statistic.unwrap)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetric.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetric.wrap(buildAwsValue())
}
object AnalyticsUtteranceMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetric =
      zio.aws.lexmodelsv2.model
        .AnalyticsUtteranceMetric(name, statistic, order.map(value => value))
    def name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName
    def statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    def order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName
    ] = ZIO.succeed(name)
    def getStatistic: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = ZIO.succeed(statistic)
    def getOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetric
  ) extends zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetric.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName =
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetricName.wrap(impl.name())
    override val statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic =
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(impl.statistic())
    override val order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetric
  ): zio.aws.lexmodelsv2.model.AnalyticsUtteranceMetric.ReadOnly = new Wrapper(
    impl
  )
}
