package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsSessionMetric(
    name: zio.aws.lexmodelsv2.model.AnalyticsSessionMetricName,
    statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic,
    order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric = {
    import AnalyticsSessionMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric
      .builder()
      .name(name.unwrap)
      .statistic(statistic.unwrap)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.wrap(buildAwsValue())
}
object AnalyticsSessionMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsSessionMetric =
      zio.aws.lexmodelsv2.model
        .AnalyticsSessionMetric(name, statistic, order.map(value => value))
    def name: zio.aws.lexmodelsv2.model.AnalyticsSessionMetricName
    def statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    def order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsSessionMetricName
    ] = ZIO.succeed(name)
    def getStatistic: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic
    ] = ZIO.succeed(statistic)
    def getOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric
  ) extends zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.AnalyticsSessionMetricName =
      zio.aws.lexmodelsv2.model.AnalyticsSessionMetricName.wrap(impl.name())
    override val statistic: zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic =
      zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic.wrap(impl.statistic())
    override val order: Optional[zio.aws.lexmodelsv2.model.AnalyticsSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric
  ): zio.aws.lexmodelsv2.model.AnalyticsSessionMetric.ReadOnly = new Wrapper(
    impl
  )
}
