package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{BotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParentBotNetwork(botId: Id, botVersion: BotVersion) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork = {
    import ParentBotNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly =
    zio.aws.lexmodelsv2.model.ParentBotNetwork.wrap(buildAwsValue())
}
object ParentBotNetwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ParentBotNetwork =
      zio.aws.lexmodelsv2.model.ParentBotNetwork(botId, botVersion)
    def botId: Id
    def botVersion: BotVersion
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork
  ) extends zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork
  ): zio.aws.lexmodelsv2.model.ParentBotNetwork.ReadOnly = new Wrapper(impl)
}
