package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputSessionStateSpecification(
    sessionAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    activeContexts: Optional[
      Iterable[zio.aws.lexmodelsv2.model.ActiveContext]
    ] = Optional.Absent,
    runtimeHints: Optional[zio.aws.lexmodelsv2.model.RuntimeHints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification = {
    import InputSessionStateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification
      .builder()
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .optionallyWith(runtimeHints.map(value => value.buildAwsValue()))(
        _.runtimeHints
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.InputSessionStateSpecification
      .wrap(buildAwsValue())
}
object InputSessionStateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.InputSessionStateSpecification =
      zio.aws.lexmodelsv2.model.InputSessionStateSpecification(
        sessionAttributes.map(value => value),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        runtimeHints.map(value => value.asEditable)
      )
    def sessionAttributes: Optional[Map[NonEmptyString, String]]
    def activeContexts
        : Optional[List[zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly]]
    def runtimeHints: Optional[zio.aws.lexmodelsv2.model.RuntimeHints.ReadOnly]
    def getSessionAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
    def getRuntimeHints
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.RuntimeHints.ReadOnly] =
      AwsError.unwrapOptionField("runtimeHints", runtimeHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification
  ) extends zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly {
    override val sessionAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val activeContexts
        : Optional[List[zio.aws.lexmodelsv2.model.ActiveContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ActiveContext.wrap(item)
          }.toList
        )
    override val runtimeHints
        : Optional[zio.aws.lexmodelsv2.model.RuntimeHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeHints())
        .map(value => zio.aws.lexmodelsv2.model.RuntimeHints.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification
  ): zio.aws.lexmodelsv2.model.InputSessionStateSpecification.ReadOnly =
    new Wrapper(impl)
}
