package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  FailureReason,
  PresignedS3Url,
  Timestamp,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeTestSetDiscrepancyReportResponse(
    testSetDiscrepancyReportId: Optional[Id] = Optional.Absent,
    testSetId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
    ] = Optional.Absent,
    testSetDiscrepancyReportStatus: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportStatus
    ] = Optional.Absent,
    lastUpdatedDataTime: Optional[Timestamp] = Optional.Absent,
    testSetDiscrepancyTopErrors: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors
    ] = Optional.Absent,
    testSetDiscrepancyRawOutputUrl: Optional[PresignedS3Url] = Optional.Absent,
    failureReasons: Optional[Iterable[FailureReason]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse = {
    import DescribeTestSetDiscrepancyReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
      .builder()
      .optionallyWith(
        testSetDiscrepancyReportId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.testSetDiscrepancyReportId)
      .optionallyWith(
        testSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        testSetDiscrepancyReportStatus.map(value => value.unwrap)
      )(_.testSetDiscrepancyReportStatus)
      .optionallyWith(
        lastUpdatedDataTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDataTime)
      .optionallyWith(
        testSetDiscrepancyTopErrors.map(value => value.buildAwsValue())
      )(_.testSetDiscrepancyTopErrors)
      .optionallyWith(
        testSetDiscrepancyRawOutputUrl.map(value =>
          PresignedS3Url.unwrap(value): java.lang.String
        )
      )(_.testSetDiscrepancyRawOutputUrl)
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
      .wrap(buildAwsValue())
}
object DescribeTestSetDiscrepancyReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse =
      zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse(
        testSetDiscrepancyReportId.map(value => value),
        testSetId.map(value => value),
        creationDateTime.map(value => value),
        target.map(value => value.asEditable),
        testSetDiscrepancyReportStatus.map(value => value),
        lastUpdatedDataTime.map(value => value),
        testSetDiscrepancyTopErrors.map(value => value.asEditable),
        testSetDiscrepancyRawOutputUrl.map(value => value),
        failureReasons.map(value => value)
      )
    def testSetDiscrepancyReportId: Optional[Id]
    def testSetId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ]
    def testSetDiscrepancyReportStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportStatus]
    def lastUpdatedDataTime: Optional[Timestamp]
    def testSetDiscrepancyTopErrors
        : Optional[zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly]
    def testSetDiscrepancyRawOutputUrl: Optional[PresignedS3Url]
    def failureReasons: Optional[List[FailureReason]]
    def getTestSetDiscrepancyReportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "testSetDiscrepancyReportId",
        testSetDiscrepancyReportId
      )
    def getTestSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetId", testSetId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getTestSetDiscrepancyReportStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportStatus
    ] = AwsError.unwrapOptionField(
      "testSetDiscrepancyReportStatus",
      testSetDiscrepancyReportStatus
    )
    def getLastUpdatedDataTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDataTime", lastUpdatedDataTime)
    def getTestSetDiscrepancyTopErrors: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly
    ] = AwsError.unwrapOptionField(
      "testSetDiscrepancyTopErrors",
      testSetDiscrepancyTopErrors
    )
    def getTestSetDiscrepancyRawOutputUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField(
        "testSetDiscrepancyRawOutputUrl",
        testSetDiscrepancyRawOutputUrl
      )
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse.ReadOnly {
    override val testSetDiscrepancyReportId: Optional[Id] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetDiscrepancyReportId())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val testSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val target: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
          .wrap(value)
      )
    override val testSetDiscrepancyReportStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetDiscrepancyReportStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportStatus.wrap(value)
        )
    override val lastUpdatedDataTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDataTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val testSetDiscrepancyTopErrors: Optional[
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetDiscrepancyTopErrors())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetDiscrepancyErrors.wrap(value)
      )
    override val testSetDiscrepancyRawOutputUrl: Optional[PresignedS3Url] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetDiscrepancyRawOutputUrl())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value)
        )
    override val failureReasons: Optional[List[FailureReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
  ): zio.aws.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse.ReadOnly =
    new Wrapper(impl)
}
