package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsSessionGroupByKey(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsSessionField] =
      Optional.Absent,
    value: Optional[AnalyticsGroupByValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey = {
    import AnalyticsSessionGroupByKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          AnalyticsGroupByValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.wrap(buildAwsValue())
}
object AnalyticsSessionGroupByKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey =
      zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsSessionField]
    def value: Optional[AnalyticsGroupByValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsSessionField] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, AnalyticsGroupByValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey
  ) extends zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly {
    override val name
        : Optional[zio.aws.lexmodelsv2.model.AnalyticsSessionField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.lexmodelsv2.model.AnalyticsSessionField.wrap(value)
        )
    override val value: Optional[AnalyticsGroupByValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsGroupByValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey
  ): zio.aws.lexmodelsv2.model.AnalyticsSessionGroupByKey.ReadOnly =
    new Wrapper(impl)
}
