package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait TestSetStatus {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus
}
object TestSetStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus
  ): zio.aws.lexmodelsv2.model.TestSetStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.IMPORTING =>
      val r = Importing
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.PENDING_ANNOTATION =>
      val r = PendingAnnotation
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.VALIDATION_ERROR =>
      val r = ValidationError
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.READY =>
      val r = Ready
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Importing extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.IMPORTING
  }
  case object PendingAnnotation
      extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.PENDING_ANNOTATION
  }
  case object Deleting extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.DELETING
  }
  case object ValidationError extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.VALIDATION_ERROR
  }
  case object Ready extends zio.aws.lexmodelsv2.model.TestSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus.READY
  }
}
