package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestSetSortBy(
    attribute: zio.aws.lexmodelsv2.model.TestSetSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetSortBy = {
    import TestSetSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetSortBy.wrap(buildAwsValue())
}
object TestSetSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetSortBy =
      zio.aws.lexmodelsv2.model.TestSetSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.TestSetSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TestSetSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetSortBy
  ) extends zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.TestSetSortAttribute =
      zio.aws.lexmodelsv2.model.TestSetSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetSortBy
  ): zio.aws.lexmodelsv2.model.TestSetSortBy.ReadOnly = new Wrapper(impl)
}
