package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  TagValue,
  Description,
  Name,
  Id,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class StartTestSetGenerationResponse(
    testSetGenerationId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    testSetGenerationStatus: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationStatus
    ] = Optional.Absent,
    testSetName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    storageLocation: Optional[
      zio.aws.lexmodelsv2.model.TestSetStorageLocation
    ] = Optional.Absent,
    generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource
    ] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    testSetTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse = {
    import StartTestSetGenerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse
      .builder()
      .optionallyWith(
        testSetGenerationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetGenerationId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(testSetGenerationStatus.map(value => value.unwrap))(
        _.testSetGenerationStatus
      )
      .optionallyWith(
        testSetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.testSetName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .optionallyWith(generationDataSource.map(value => value.buildAwsValue()))(
        _.generationDataSource
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        testSetTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testSetTags)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse
      .wrap(buildAwsValue())
}
object StartTestSetGenerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse =
      zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse(
        testSetGenerationId.map(value => value),
        creationDateTime.map(value => value),
        testSetGenerationStatus.map(value => value),
        testSetName.map(value => value),
        description.map(value => value),
        storageLocation.map(value => value.asEditable),
        generationDataSource.map(value => value.asEditable),
        roleArn.map(value => value),
        testSetTags.map(value => value)
      )
    def testSetGenerationId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def testSetGenerationStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetGenerationStatus]
    def testSetName: Optional[Name]
    def description: Optional[Description]
    def storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly]
    def generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ]
    def roleArn: Optional[RoleArn]
    def testSetTags: Optional[Map[TagKey, TagValue]]
    def getTestSetGenerationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetGenerationId", testSetGenerationId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getTestSetGenerationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetGenerationStatus
    ] = AwsError.unwrapOptionField(
      "testSetGenerationStatus",
      testSetGenerationStatus
    )
    def getTestSetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("testSetName", testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStorageLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    ] = AwsError.unwrapOptionField("storageLocation", storageLocation)
    def getGenerationDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("generationDataSource", generationDataSource)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTestSetTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testSetTags", testSetTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse
  ) extends zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse.ReadOnly {
    override val testSetGenerationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetGenerationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val testSetGenerationStatus
        : Optional[zio.aws.lexmodelsv2.model.TestSetGenerationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetGenerationStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetGenerationStatus.wrap(value)
        )
    override val testSetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLocation())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetStorageLocation.wrap(value)
        )
    override val generationDataSource: Optional[
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.generationDataSource())
      .map(value =>
        zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.wrap(value)
      )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val testSetTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSetTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives.TagKey(
                key
              ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse
  ): zio.aws.lexmodelsv2.model.StartTestSetGenerationResponse.ReadOnly =
    new Wrapper(impl)
}
