package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportSortBy(
    attribute: zio.aws.lexmodelsv2.model.ImportSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportSortBy = {
    import ImportSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ImportSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportSortBy.wrap(buildAwsValue())
}
object ImportSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportSortBy =
      zio.aws.lexmodelsv2.model.ImportSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.ImportSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ImportSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSortBy
  ) extends zio.aws.lexmodelsv2.model.ImportSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.ImportSortAttribute =
      zio.aws.lexmodelsv2.model.ImportSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSortBy
  ): zio.aws.lexmodelsv2.model.ImportSortBy.ReadOnly = new Wrapper(impl)
}
