package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  Count,
  Description,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateTestSetResponse(
    testSetId: Optional[Id] = Optional.Absent,
    testSetName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    modality: Optional[zio.aws.lexmodelsv2.model.TestSetModality] =
      Optional.Absent,
    status: Optional[zio.aws.lexmodelsv2.model.TestSetStatus] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    numTurns: Optional[Count] = Optional.Absent,
    storageLocation: Optional[
      zio.aws.lexmodelsv2.model.TestSetStorageLocation
    ] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse = {
    import UpdateTestSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse
      .builder()
      .optionallyWith(
        testSetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.testSetId)
      .optionallyWith(
        testSetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.testSetName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(modality.map(value => value.unwrap))(_.modality)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(numTurns.map(value => Count.unwrap(value): Integer))(
        _.numTurns
      )
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateTestSetResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateTestSetResponse.wrap(buildAwsValue())
}
object UpdateTestSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateTestSetResponse =
      zio.aws.lexmodelsv2.model.UpdateTestSetResponse(
        testSetId.map(value => value),
        testSetName.map(value => value),
        description.map(value => value),
        modality.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        numTurns.map(value => value),
        storageLocation.map(value => value.asEditable),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def testSetId: Optional[Id]
    def testSetName: Optional[Name]
    def description: Optional[Description]
    def modality: Optional[zio.aws.lexmodelsv2.model.TestSetModality]
    def status: Optional[zio.aws.lexmodelsv2.model.TestSetStatus]
    def roleArn: Optional[RoleArn]
    def numTurns: Optional[Count]
    def storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getTestSetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("testSetId", testSetId)
    def getTestSetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("testSetName", testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getModality
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestSetModality] =
      AwsError.unwrapOptionField("modality", modality)
    def getStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getNumTurns: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("numTurns", numTurns)
    def getStorageLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly
    ] = AwsError.unwrapOptionField("storageLocation", storageLocation)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateTestSetResponse.ReadOnly {
    override val testSetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val testSetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.testSetName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val modality: Optional[zio.aws.lexmodelsv2.model.TestSetModality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modality())
        .map(value => zio.aws.lexmodelsv2.model.TestSetModality.wrap(value))
    override val status: Optional[zio.aws.lexmodelsv2.model.TestSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lexmodelsv2.model.TestSetStatus.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val numTurns: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.numTurns())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Count(value))
    override val storageLocation
        : Optional[zio.aws.lexmodelsv2.model.TestSetStorageLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLocation())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestSetStorageLocation.wrap(value)
        )
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse
  ): zio.aws.lexmodelsv2.model.UpdateTestSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
