package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTestSetRequest(
    testSetId: Id,
    testSetName: Name,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest = {
    import UpdateTestSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .testSetName(Name.unwrap(testSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateTestSetRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateTestSetRequest.wrap(buildAwsValue())
}
object UpdateTestSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateTestSetRequest =
      zio.aws.lexmodelsv2.model.UpdateTestSetRequest(
        testSetId,
        testSetName,
        description.map(value => value)
      )
    def testSetId: Id
    def testSetName: Name
    def description: Optional[Description]
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
    def getTestSetName: ZIO[Any, Nothing, Name] = ZIO.succeed(testSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateTestSetRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
    override val testSetName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.testSetName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest
  ): zio.aws.lexmodelsv2.model.UpdateTestSetRequest.ReadOnly = new Wrapper(impl)
}
