package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestSetGenerationDataSource(
    conversationLogsDataSource: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogsDataSource
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource = {
    import TestSetGenerationDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource
      .builder()
      .optionallyWith(
        conversationLogsDataSource.map(value => value.buildAwsValue())
      )(_.conversationLogsDataSource)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.wrap(buildAwsValue())
}
object TestSetGenerationDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetGenerationDataSource =
      zio.aws.lexmodelsv2.model.TestSetGenerationDataSource(
        conversationLogsDataSource.map(value => value.asEditable)
      )
    def conversationLogsDataSource: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly
    ]
    def getConversationLogsDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogsDataSource",
      conversationLogsDataSource
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource
  ) extends zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly {
    override val conversationLogsDataSource: Optional[
      zio.aws.lexmodelsv2.model.ConversationLogsDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conversationLogsDataSource())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConversationLogsDataSource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource
  ): zio.aws.lexmodelsv2.model.TestSetGenerationDataSource.ReadOnly =
    new Wrapper(impl)
}
