package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait TestResultMatchStatus {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus
}
object TestResultMatchStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus
  ): zio.aws.lexmodelsv2.model.TestResultMatchStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.MATCHED =>
      val r = Matched
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.MISMATCHED =>
      val r = Mismatched
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.EXECUTION_ERROR =>
      val r = ExecutionError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestResultMatchStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Matched extends zio.aws.lexmodelsv2.model.TestResultMatchStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.MATCHED
  }
  case object Mismatched
      extends zio.aws.lexmodelsv2.model.TestResultMatchStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.MISMATCHED
  }
  case object ExecutionError
      extends zio.aws.lexmodelsv2.model.TestResultMatchStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus.EXECUTION_ERROR
  }
}
