package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait AnalyticsMetricStatistic {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic
}
object AnalyticsMetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic
  ): zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.AVG =>
      val r = Avg
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.MAX =>
      val r = Max
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Sum extends zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.SUM
  }
  case object Avg extends zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.AVG
  }
  case object Max extends zio.aws.lexmodelsv2.model.AnalyticsMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic =
      software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsMetricStatistic.MAX
  }
}
