package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyticsIntentStageFilter(
    name: zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilterName,
    operator: zio.aws.lexmodelsv2.model.AnalyticsFilterOperator,
    values: Iterable[AnalyticsFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter = {
    import AnalyticsIntentStageFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter
      .builder()
      .name(name.unwrap)
      .operator(operator.unwrap)
      .values(values.map { item =>
        AnalyticsFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilter.wrap(buildAwsValue())
}
object AnalyticsIntentStageFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilter =
      zio.aws.lexmodelsv2.model
        .AnalyticsIntentStageFilter(name, operator, values)
    def name: zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilterName
    def operator: zio.aws.lexmodelsv2.model.AnalyticsFilterOperator
    def values: List[AnalyticsFilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilterName
    ] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.AnalyticsFilterOperator] =
      ZIO.succeed(operator)
    def getValues: ZIO[Any, Nothing, List[AnalyticsFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter
  ) extends zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilter.ReadOnly {
    override val name
        : zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilterName =
      zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilterName.wrap(impl.name())
    override val operator: zio.aws.lexmodelsv2.model.AnalyticsFilterOperator =
      zio.aws.lexmodelsv2.model.AnalyticsFilterOperator.wrap(impl.operator())
    override val values: List[AnalyticsFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageFilter
  ): zio.aws.lexmodelsv2.model.AnalyticsIntentStageFilter.ReadOnly =
    new Wrapper(impl)
}
