package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait TestSetModality {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality
}
object TestSetModality {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality
  ): zio.aws.lexmodelsv2.model.TestSetModality = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.TEXT =>
      val r = Text
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.AUDIO =>
      val r = Audio
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TestSetModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.UNKNOWN_TO_SDK_VERSION
  }
  case object Text extends zio.aws.lexmodelsv2.model.TestSetModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.TEXT
  }
  case object Audio extends zio.aws.lexmodelsv2.model.TestSetModality {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality =
      software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality.AUDIO
  }
}
