package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestExecutionResultItems(
    overallTestResults: Optional[zio.aws.lexmodelsv2.model.OverallTestResults] =
      Optional.Absent,
    conversationLevelTestResults: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResults
    ] = Optional.Absent,
    intentClassificationTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResults
    ] = Optional.Absent,
    intentLevelSlotResolutionTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResults
    ] = Optional.Absent,
    utteranceLevelTestResults: Optional[
      zio.aws.lexmodelsv2.model.UtteranceLevelTestResults
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultItems = {
    import TestExecutionResultItems.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultItems
      .builder()
      .optionallyWith(overallTestResults.map(value => value.buildAwsValue()))(
        _.overallTestResults
      )
      .optionallyWith(
        conversationLevelTestResults.map(value => value.buildAwsValue())
      )(_.conversationLevelTestResults)
      .optionallyWith(
        intentClassificationTestResults.map(value => value.buildAwsValue())
      )(_.intentClassificationTestResults)
      .optionallyWith(
        intentLevelSlotResolutionTestResults.map(value => value.buildAwsValue())
      )(_.intentLevelSlotResolutionTestResults)
      .optionallyWith(
        utteranceLevelTestResults.map(value => value.buildAwsValue())
      )(_.utteranceLevelTestResults)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly =
    zio.aws.lexmodelsv2.model.TestExecutionResultItems.wrap(buildAwsValue())
}
object TestExecutionResultItems {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultItems
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestExecutionResultItems =
      zio.aws.lexmodelsv2.model.TestExecutionResultItems(
        overallTestResults.map(value => value.asEditable),
        conversationLevelTestResults.map(value => value.asEditable),
        intentClassificationTestResults.map(value => value.asEditable),
        intentLevelSlotResolutionTestResults.map(value => value.asEditable),
        utteranceLevelTestResults.map(value => value.asEditable)
      )
    def overallTestResults
        : Optional[zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly]
    def conversationLevelTestResults: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResults.ReadOnly
    ]
    def intentClassificationTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly
    ]
    def intentLevelSlotResolutionTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResults.ReadOnly
    ]
    def utteranceLevelTestResults
        : Optional[zio.aws.lexmodelsv2.model.UtteranceLevelTestResults.ReadOnly]
    def getOverallTestResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly
    ] = AwsError.unwrapOptionField("overallTestResults", overallTestResults)
    def getConversationLevelTestResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLevelTestResults.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLevelTestResults",
      conversationLevelTestResults
    )
    def getIntentClassificationTestResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intentClassificationTestResults",
      intentClassificationTestResults
    )
    def getIntentLevelSlotResolutionTestResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResults.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intentLevelSlotResolutionTestResults",
      intentLevelSlotResolutionTestResults
    )
    def getUtteranceLevelTestResults: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UtteranceLevelTestResults.ReadOnly
    ] = AwsError.unwrapOptionField(
      "utteranceLevelTestResults",
      utteranceLevelTestResults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultItems
  ) extends zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly {
    override val overallTestResults
        : Optional[zio.aws.lexmodelsv2.model.OverallTestResults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overallTestResults())
        .map(value => zio.aws.lexmodelsv2.model.OverallTestResults.wrap(value))
    override val conversationLevelTestResults: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelTestResults.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conversationLevelTestResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConversationLevelTestResults.wrap(value)
      )
    override val intentClassificationTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentClassificationTestResults.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.intentClassificationTestResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.IntentClassificationTestResults.wrap(value)
      )
    override val intentLevelSlotResolutionTestResults: Optional[
      zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResults.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.intentLevelSlotResolutionTestResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.IntentLevelSlotResolutionTestResults
          .wrap(value)
      )
    override val utteranceLevelTestResults: Optional[
      zio.aws.lexmodelsv2.model.UtteranceLevelTestResults.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceLevelTestResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.UtteranceLevelTestResults.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionResultItems
  ): zio.aws.lexmodelsv2.model.TestExecutionResultItems.ReadOnly = new Wrapper(
    impl
  )
}
