package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SlotTypeValue(
    sampleValue: Optional[zio.aws.lexmodelsv2.model.SampleValue] =
      Optional.Absent,
    synonyms: Optional[Iterable[zio.aws.lexmodelsv2.model.SampleValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue = {
    import SlotTypeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue
      .builder()
      .optionallyWith(sampleValue.map(value => value.buildAwsValue()))(
        _.sampleValue
      )
      .optionallyWith(
        synonyms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.synonyms)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotTypeValue.wrap(buildAwsValue())
}
object SlotTypeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotTypeValue =
      zio.aws.lexmodelsv2.model.SlotTypeValue(
        sampleValue.map(value => value.asEditable),
        synonyms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sampleValue: Optional[zio.aws.lexmodelsv2.model.SampleValue.ReadOnly]
    def synonyms: Optional[List[zio.aws.lexmodelsv2.model.SampleValue.ReadOnly]]
    def getSampleValue
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SampleValue.ReadOnly] =
      AwsError.unwrapOptionField("sampleValue", sampleValue)
    def getSynonyms: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleValue.ReadOnly
    ]] = AwsError.unwrapOptionField("synonyms", synonyms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue
  ) extends zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly {
    override val sampleValue
        : Optional[zio.aws.lexmodelsv2.model.SampleValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleValue())
        .map(value => zio.aws.lexmodelsv2.model.SampleValue.wrap(value))
    override val synonyms
        : Optional[List[zio.aws.lexmodelsv2.model.SampleValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.synonyms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeValue
  ): zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly = new Wrapper(impl)
}
