package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.Count
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OverallTestResultItem(
    multiTurnConversation: Boolean,
    totalResultCount: Count,
    speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = Optional.Absent,
    endToEndResultCounts: Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem = {
    import OverallTestResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem
      .builder()
      .multiTurnConversation(multiTurnConversation: java.lang.Boolean)
      .totalResultCount(Count.unwrap(totalResultCount): Integer)
      .optionallyWith(
        speechTranscriptionResultCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (Count.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.speechTranscriptionResultCountsWithStrings)
      .endToEndResultCountsWithStrings(
        endToEndResultCounts
          .map({ case (key, value) =>
            key.unwrap.toString -> (Count.unwrap(value): Integer)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly =
    zio.aws.lexmodelsv2.model.OverallTestResultItem.wrap(buildAwsValue())
}
object OverallTestResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.OverallTestResultItem =
      zio.aws.lexmodelsv2.model.OverallTestResultItem(
        multiTurnConversation,
        totalResultCount,
        speechTranscriptionResultCounts.map(value => value),
        endToEndResultCounts
      )
    def multiTurnConversation: Boolean
    def totalResultCount: Count
    def speechTranscriptionResultCounts
        : Optional[Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]]
    def endToEndResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    def getMultiTurnConversation: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(multiTurnConversation)
    def getTotalResultCount: ZIO[Any, Nothing, Count] =
      ZIO.succeed(totalResultCount)
    def getSpeechTranscriptionResultCounts: ZIO[Any, AwsError, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = AwsError.unwrapOptionField(
      "speechTranscriptionResultCounts",
      speechTranscriptionResultCounts
    )
    def getEndToEndResultCounts: ZIO[Any, Nothing, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = ZIO.succeed(endToEndResultCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem
  ) extends zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly {
    override val multiTurnConversation: Boolean =
      impl.multiTurnConversation(): Boolean
    override val totalResultCount: Count =
      zio.aws.lexmodelsv2.model.primitives.Count(impl.totalResultCount())
    override val speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speechTranscriptionResultCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.TestResultMatchStatus
              .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
          })
          .toMap
      )
    override val endToEndResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count] = impl
      .endToEndResultCounts()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lexmodelsv2.model.TestResultMatchStatus
          .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OverallTestResultItem
  ): zio.aws.lexmodelsv2.model.OverallTestResultItem.ReadOnly = new Wrapper(
    impl
  )
}
