package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTestExecutionsResponse(
    testExecutions: Optional[
      Iterable[zio.aws.lexmodelsv2.model.TestExecutionSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse = {
    import ListTestExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse
      .builder()
      .optionallyWith(
        testExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListTestExecutionsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListTestExecutionsResponse.wrap(buildAwsValue())
}
object ListTestExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListTestExecutionsResponse =
      zio.aws.lexmodelsv2.model.ListTestExecutionsResponse(
        testExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def testExecutions: Optional[
      List[zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getTestExecutions: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("testExecutions", testExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse
  ) extends zio.aws.lexmodelsv2.model.ListTestExecutionsResponse.ReadOnly {
    override val testExecutions: Optional[
      List[zio.aws.lexmodelsv2.model.TestExecutionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.TestExecutionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse
  ): zio.aws.lexmodelsv2.model.ListTestExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
