package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBotsResponse(
    botSummaries: Optional[Iterable[zio.aws.lexmodelsv2.model.BotSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse = {
    import ListBotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
      .builder()
      .optionallyWith(
        botSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotsResponse.wrap(buildAwsValue())
}
object ListBotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotsResponse =
      zio.aws.lexmodelsv2.model.ListBotsResponse(
        botSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getBotSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botSummaries", botSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly {
    override val botSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.BotSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ): zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly = new Wrapper(impl)
}
