package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExportRequest(exportId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest = {
    import DescribeExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest
      .builder()
      .exportId(Id.unwrap(exportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeExportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeExportRequest.wrap(buildAwsValue())
}
object DescribeExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeExportRequest =
      zio.aws.lexmodelsv2.model.DescribeExportRequest(exportId)
    def exportId: Id
    def getExportId: ZIO[Any, Nothing, Id] = ZIO.succeed(exportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeExportRequest.ReadOnly {
    override val exportId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.exportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest
  ): zio.aws.lexmodelsv2.model.DescribeExportRequest.ReadOnly = new Wrapper(
    impl
  )
}
