package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateTestSetDiscrepancyReportRequest(
    testSetId: Id,
    target: zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest = {
    import CreateTestSetDiscrepancyReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
      .builder()
      .testSetId(Id.unwrap(testSetId): java.lang.String)
      .target(target.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
      .wrap(buildAwsValue())
}
object CreateTestSetDiscrepancyReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest =
      zio.aws.lexmodelsv2.model
        .CreateTestSetDiscrepancyReportRequest(testSetId, target.asEditable)
    def testSetId: Id
    def target
        : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    def getTestSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(testSetId)
    def getTarget: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly
    ] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
  ) extends zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest.ReadOnly {
    override val testSetId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.testSetId())
    override val target
        : zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget.ReadOnly =
      zio.aws.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
        .wrap(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
  ): zio.aws.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest.ReadOnly =
    new Wrapper(impl)
}
