package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Name,
  TestResultSlotName,
  TestSetAgentPrompt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AgentTurnResult(
    expectedAgentPrompt: TestSetAgentPrompt,
    actualAgentPrompt: Optional[TestSetAgentPrompt] = Optional.Absent,
    errorDetails: Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails] =
      Optional.Absent,
    actualElicitedSlot: Optional[TestResultSlotName] = Optional.Absent,
    actualIntent: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AgentTurnResult = {
    import AgentTurnResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AgentTurnResult
      .builder()
      .expectedAgentPrompt(
        TestSetAgentPrompt.unwrap(expectedAgentPrompt): java.lang.String
      )
      .optionallyWith(
        actualAgentPrompt.map(value =>
          TestSetAgentPrompt.unwrap(value): java.lang.String
        )
      )(_.actualAgentPrompt)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .optionallyWith(
        actualElicitedSlot.map(value =>
          TestResultSlotName.unwrap(value): java.lang.String
        )
      )(_.actualElicitedSlot)
      .optionallyWith(
        actualIntent.map(value => Name.unwrap(value): java.lang.String)
      )(_.actualIntent)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly =
    zio.aws.lexmodelsv2.model.AgentTurnResult.wrap(buildAwsValue())
}
object AgentTurnResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AgentTurnResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AgentTurnResult =
      zio.aws.lexmodelsv2.model.AgentTurnResult(
        expectedAgentPrompt,
        actualAgentPrompt.map(value => value),
        errorDetails.map(value => value.asEditable),
        actualElicitedSlot.map(value => value),
        actualIntent.map(value => value)
      )
    def expectedAgentPrompt: TestSetAgentPrompt
    def actualAgentPrompt: Optional[TestSetAgentPrompt]
    def errorDetails
        : Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly]
    def actualElicitedSlot: Optional[TestResultSlotName]
    def actualIntent: Optional[Name]
    def getExpectedAgentPrompt: ZIO[Any, Nothing, TestSetAgentPrompt] =
      ZIO.succeed(expectedAgentPrompt)
    def getActualAgentPrompt: ZIO[Any, AwsError, TestSetAgentPrompt] =
      AwsError.unwrapOptionField("actualAgentPrompt", actualAgentPrompt)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getActualElicitedSlot: ZIO[Any, AwsError, TestResultSlotName] =
      AwsError.unwrapOptionField("actualElicitedSlot", actualElicitedSlot)
    def getActualIntent: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("actualIntent", actualIntent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AgentTurnResult
  ) extends zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly {
    override val expectedAgentPrompt: TestSetAgentPrompt =
      zio.aws.lexmodelsv2.model.primitives
        .TestSetAgentPrompt(impl.expectedAgentPrompt())
    override val actualAgentPrompt: Optional[TestSetAgentPrompt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualAgentPrompt())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestSetAgentPrompt(value)
        )
    override val errorDetails
        : Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value =>
          zio.aws.lexmodelsv2.model.ExecutionErrorDetails.wrap(value)
        )
    override val actualElicitedSlot: Optional[TestResultSlotName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualElicitedSlot())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.TestResultSlotName(value)
        )
    override val actualIntent: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.actualIntent())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AgentTurnResult
  ): zio.aws.lexmodelsv2.model.AgentTurnResult.ReadOnly = new Wrapper(impl)
}
